/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.logging;

import filenet.vw.api.VWException;
import filenet.vw.base.IVWConsole;
import filenet.vw.base.logging.IVWConsoleHandler;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class VWConsoleHandler
extends ConsoleAppender
implements IVWConsoleHandler {
    private Remote m_remoteObj = null;
    protected List consoles = null;
    protected List consoleLogLevel = null;

    public static VWConsoleHandler getGlobalHandler() {
        Iterator appenders = Logger.getAPPENDERSIterator();
        while (appenders.hasNext()) {
            Appender a = (Appender)appenders.next();
            if (!(a instanceof VWConsoleHandler)) continue;
            return (VWConsoleHandler)a;
        }
        return null;
    }

    public static void installGlobalHandler() {
        if (VWConsoleHandler.getGlobalHandler() == null) {
            try {
                Logger.installAppender((Appender)new VWConsoleHandler());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deInstallGlobalHandler() {
        VWConsoleHandler handler = VWConsoleHandler.getGlobalHandler();
        if (handler != null) {
            VWConsoleHandler vWConsoleHandler = handler;
            synchronized (vWConsoleHandler) {
                handler.removeFromRMI();
            }
        }
    }

    public VWConsoleHandler() throws RemoteException {
        this.setName("VWConsoleHandler");
        this.m_remoteObj = UnicastRemoteObject.exportObject(this);
        String peLogLevel = System.getProperty("PELogLevel");
        if (peLogLevel != null) {
            org.apache.log4j.Level l = Level.toLevel(peLogLevel);
            this.setThreshold((Priority)l);
        } else {
            this.setThreshold((Priority)Level.INFO);
        }
    }

    protected void removeFromRMI() {
        try {
            if (this.m_remoteObj != null) {
                UnicastRemoteObject.unexportObject(this.m_remoteObj, true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAppend(LoggingEvent record) {
        try {
            int level = record.getLevel().toInt();
            if (level < 20000) {
                return;
            }
            VWConsoleHandler vWConsoleHandler = this;
            synchronized (vWConsoleHandler) {
                if (this.consoles != null) {
                    IVWConsole console = null;
                    for (int i = 0; i < this.consoles.size(); ++i) {
                        try {
                            if (!record.getLevel().isGreaterOrEqual((Priority)((org.apache.log4j.Level)this.consoleLogLevel.get(i)))) continue;
                            StringBuffer msg = new StringBuffer().append(record.getRenderedMessage());
                            String[] strs = record.getThrowableStrRep();
                            if (strs != null) {
                                msg.append("\n\n");
                                for (int ii = 0; ii < strs.length; ++ii) {
                                    msg.append("\t").append(strs[ii]).append("\n");
                                }
                            }
                            console = (IVWConsole)this.consoles.get(i);
                            console.writeMessage(new Level(record.getLevel()), msg.toString());
                            continue;
                        }
                        catch (RemoteException e) {
                            try {
                                this.removeConsole(console);
                            }
                            catch (Exception ex) {}
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            LogLog.warn((String)"VWConsoleHandler.append", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConsoleNames() {
        VWConsoleHandler vWConsoleHandler = this;
        synchronized (vWConsoleHandler) {
            if (this.consoles == null || this.consoles.isEmpty()) {
                return null;
            }
            ArrayList<String> names = new ArrayList<String>();
            if (this.consoles != null) {
                Iterator i = this.consoles.iterator();
                while (i.hasNext()) {
                    try {
                        names.add(((IVWConsole)i.next()).getConsoleName());
                    }
                    catch (Exception ex) {}
                }
            }
            return names.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsole(IVWConsole object, Level level) throws RemoteException, VWException {
        VWConsoleHandler vWConsoleHandler = this;
        synchronized (vWConsoleHandler) {
            try {
                if (this.consoles == null) {
                    this.consoles = new ArrayList();
                    this.consoleLogLevel = new ArrayList();
                }
                if (!this.consoles.contains(object)) {
                    this.consoles.add(object);
                    this.consoleLogLevel.add(level);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsole(IVWConsole object, int level) throws RemoteException, VWException {
        VWConsoleHandler vWConsoleHandler = this;
        synchronized (vWConsoleHandler) {
            try {
                if (this.consoles == null) {
                    this.consoles = new ArrayList();
                    this.consoleLogLevel = new ArrayList();
                }
                if (!this.consoles.contains(object)) {
                    this.consoles.add(object);
                    this.consoleLogLevel.add(Level.parse(Integer.toString(level)));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsole(IVWConsole theConsole) throws RemoteException, VWException {
        VWConsoleHandler vWConsoleHandler = this;
        synchronized (vWConsoleHandler) {
            if (this.consoles != null && this.consoles.contains(theConsole)) {
                int inx = this.consoles.indexOf(theConsole);
                this.consoles.remove(theConsole);
                this.consoleLogLevel.remove(inx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsoleLevel(IVWConsole theConsole, Level level) throws RemoteException, VWException {
        VWConsoleHandler vWConsoleHandler = this;
        synchronized (vWConsoleHandler) {
            if (this.consoles != null && this.consoles.contains(theConsole)) {
                int inx = this.consoles.indexOf(theConsole);
                this.consoleLogLevel.add(inx, level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsoleLevel(IVWConsole theConsole, int level) throws RemoteException, VWException {
        VWConsoleHandler vWConsoleHandler = this;
        synchronized (vWConsoleHandler) {
            if (this.consoles != null && this.consoles.contains(theConsole)) {
                int inx = this.consoles.indexOf(theConsole);
                this.consoleLogLevel.add(inx, Level.parse(Integer.toString(level)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Level getConsoleLevel(IVWConsole theConsole) throws RemoteException, VWException {
        VWConsoleHandler vWConsoleHandler = this;
        synchronized (vWConsoleHandler) {
            Level result = null;
            if (this.consoles != null && this.consoles.contains(theConsole)) {
                int inx = this.consoles.indexOf(theConsole);
                result = (Level)this.consoleLogLevel.get(inx);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIntConsoleLevel(IVWConsole theConsole) throws RemoteException, VWException {
        VWConsoleHandler vWConsoleHandler = this;
        synchronized (vWConsoleHandler) {
            Level result = null;
            if (this.consoles != null && this.consoles.contains(theConsole)) {
                int inx = this.consoles.indexOf(theConsole);
                result = (Level)this.consoleLogLevel.get(inx);
            }
            if (result != null) {
                return result.intValue();
            }
            return -1;
        }
    }

    public Vector getProperties() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public boolean getLoggingState() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void setLoggingState(boolean logState) throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public boolean getTracingState() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void setTracingState(boolean state) throws RemoteException {
        throw new RemoteException("Not applicable");
    }
}

